/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.ObjectAnimator;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.core.Choreographer;
import icyllis.modernui.core.Core;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AnimationHandler {
    private static final ThreadLocal<AnimationHandler> sAnimatorHandler = new ThreadLocal();
    private final ArrayList<FrameCallback> mAnimationCallbacks = new ArrayList();
    private final Object2LongOpenHashMap<FrameCallback> mDelayedStartTime = new Object2LongOpenHashMap();
    private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

        @Override
        public void doFrame(@NonNull Choreographer choreographer, long frameTimeNanos) {
            AnimationHandler.this.doAnimationFrame(frameTimeNanos / 1000000L);
            if (AnimationHandler.this.mAnimationCallbacks.size() > 0) {
                choreographer.postFrameCallback(this);
            }
        }
    };
    private boolean mListDirty = false;

    private AnimationHandler() {
    }

    @NonNull
    public static AnimationHandler getInstance() {
        if (sAnimatorHandler.get() == null) {
            sAnimatorHandler.set(new AnimationHandler());
        }
        return sAnimatorHandler.get();
    }

    public static int getAnimationCount() {
        AnimationHandler handler = sAnimatorHandler.get();
        if (handler == null) {
            return 0;
        }
        return handler.getCallbackSize();
    }

    public void addFrameCallback(@NonNull FrameCallback callback, long delay) {
        boolean newlyAdded;
        if (this.mAnimationCallbacks.isEmpty()) {
            Choreographer.getInstance().postFrameCallback(this.mFrameCallback);
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
            newlyAdded = true;
        } else {
            newlyAdded = false;
        }
        if (delay > 0L) {
            this.mDelayedStartTime.put((Object)callback, Core.timeMillis() + delay);
        } else if (!newlyAdded) {
            this.mDelayedStartTime.removeLong((Object)callback);
        }
    }

    public void removeCallback(@NonNull FrameCallback callback) {
        int id2 = this.mAnimationCallbacks.indexOf(callback);
        if (id2 >= 0) {
            this.mAnimationCallbacks.set(id2, null);
            this.mDelayedStartTime.removeLong((Object)callback);
            this.mListDirty = true;
        }
    }

    private void doAnimationFrame(long frameTime) {
        long currentTime = Core.timeMillis();
        int size = this.mAnimationCallbacks.size();
        for (int i = 0; i < size; ++i) {
            FrameCallback callback = this.mAnimationCallbacks.get(i);
            if (callback == null || !this.isCallbackDue(callback, currentTime)) continue;
            callback.doAnimationFrame(frameTime);
        }
        this.cleanUpList();
    }

    private boolean isCallbackDue(@NonNull FrameCallback callback, long currentTime) {
        long startTime = this.mDelayedStartTime.getLong((Object)callback);
        if (startTime == 0L) {
            return true;
        }
        if (currentTime >= startTime) {
            this.mDelayedStartTime.removeLong((Object)callback);
            return true;
        }
        return false;
    }

    void autoCancelBasedOn(@NonNull ObjectAnimator animator) {
        for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
            FrameCallback cb = this.mAnimationCallbacks.get(i);
            if (cb == null || !animator.shouldAutoCancel(cb)) continue;
            ((Animator)((Object)cb)).cancel();
        }
    }

    private void cleanUpList() {
        if (this.mListDirty) {
            for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
                if (this.mAnimationCallbacks.get(i) != null) continue;
                this.mAnimationCallbacks.remove(i);
            }
            this.mListDirty = false;
        }
    }

    private int getCallbackSize() {
        int count = 0;
        for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
            if (this.mAnimationCallbacks.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static interface FrameCallback {
        public boolean doAnimationFrame(long var1);
    }
}

